-- new script file

function OnAfterSceneLoaded(self)
  self:AddTriggerTarget("unitKilled")  
  self:AddTriggerTarget("unitKilled")
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.active = true
      self.defCount = 7
    end
  end
  
  if self.active then
    if self.defCount <= 0 then
      self.p0:SwitchOwnership(Game:GetEntity(self:GetKey()), 0)
      self.active = false      
    end  
  end
end

function OnTrigger(self, source, target)
  if target == "unitKilled" then
    self.defCount = self.defCount - 1
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.active = ar:Read()
    self.defCount = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.active)
    ar:Write(self.defCount)
  end
end
